module net.BurtonRadons.dedit.fileCommands;

import net.BurtonRadons.dedit.main;
import std.file;
import std.path;

void RenameFile (View view, Document document)
{
    char [] [] result;

    with (new FileSelector (true))
    {
        addFilter ("All Files", "*");
        filename = document.filename;
        overwritePrompt = true;
        result = run ();
    }

    if (!result.length)
        return;
    try std.file.remove (result [0]);
    catch (std.file.FileException) { }
    std.file.rename (document.filename, result [0]);
    document.filename = result [0].dup;
    global.documentRenamed (document);
    view.setCaption ();
}

/** Provides the file-handling command set. */
class FileCommands
{
    static this () { new FileCommands (); }

    this ()
    {
        alias View.addCommand e;

        e ("FileOpen", ".", &FileOpen,
            "Open a file.",
            "Show a dialog to open a file or a set of files.  If the user doesn't "
            "cancel, the files are inserted into the current folder (either the "
            "folder the current document is in or the folder that has been made "
            "current by a right-clicked drop-down box on the folder in the project "
            "view.");
        e ("FileSave", "?", &FileSave,
            "Save the current file.",
            "Save the current file.  If this is a new file, it asks the user for a name "
            "before saving.  If this dialog is canceled, the file is not saved.");
        e ("FileSaveAll", "", &FileSaveAll,
            "Save all files.",
            "Save all files.  If there are any new files, it asks the user for a name "
            "before saving.  If this dialog is canceled, that file is not saved but "
            "the rest are.");
        e ("FileClose", "", &FileClose,
            "Close the current file.",
            "Close the current file.  If this is the last open file, it immediately creates "
            "a new empty file.  If the file is modified, it first asks to save it.");
        e ("FileNew", "", &FileNew,
            "Create a new file.",
            "Create a new file.  The file will be created in either the folder the current "
            "document is in or the folder that has been made temporarily current by "
            "a right-clicked drop-down box on the folder in the project view.");
        e ("FileRename", "", &FileRename,
            "Rename the current file.",
            "Rename the current file.  This brings up a dialog asking for the new "
            "filename.  If the dialog is canceled, nothing is done.  Otherwise it saves "
            "the file to the new name and deletes the previous name on success.");
    }

    void FileNew (View view)
    {
        view.newDocument ();
    }

    void FileClose (View view)
    {
        with (view)
        {
            int index;

            global.documentRemoved (document);

            for (int c; c < documents.length; c ++)
                if (documents [c] == document)
                {
                    for (int d = c; d < documents.length - 1; d ++)
                        documents [d] = documents [d + 1];
                    index = 0;
                    documents = documents [0 .. documents.length - 1];
                    break;
                }

            for (int c; c < ordered.length; c ++)
                if (ordered [c] == document)
                {
                    for (int d = c; d < ordered.length - 1; d ++)
                        ordered [d] = ordered [d + 1];
                    index = 0;
                    ordered = ordered [0 .. ordered.length - 1];
                    break;
                }

            if (ordered.length)
                switchDocument (ordered [0]);
            else
                newDocument ();
        }
    }

    void FileSave (View view)
    {
        view.document.save ();
    }

    void FileSaveAll (View view)
    {
        with (view)
        {
            for (int c; c < documents.length; c ++)
            {
                if (documents [c].modified)
                    documents [c].save ();
            }
        }
    }

    void FileOpen (View view)
    {
        SyntaxHighlighter [] list = SyntaxHighlighter.list;
        char [] [] result;

        with (view)
        {
            with (new FileSelector (false))
            {
                multiSelect = true;
                addFilter ("All Files", "*");
                for (int c; c < list.length; c ++)
                {
                    char [] exts = list [c].exts ();
                    char [] name = list [c].name ();

                    if (exts !== null)
                        addFilter (name, exts);
                }

                result = run ();
                if (result === null)
                    return;
            }

            char [] [] errors;
    
            for (int c; c < result.length; c ++)
            {
                try view.loadFile (result [c]);
                catch (std.file.FileException)
                    errors ~= result [c];
            }

            if (errors.length)
            {
                char [] message;

                message = "These files cannot be opened and will be removed from the project:\n\n";
                for (int c; c < errors.length; c ++)
                    message ~= errors [c] ~ "\n";
            }

            clean ();
        }
    }

    void FileRename (View view)
    {
        RenameFile (view, view.document);
    }
}
